//-----------------------------------------------------------------------------
// Microsoft OLE DB RowsetViewer
// Copyright (C) 1994 - 1998 By Microsoft Corporation.
//
// @doc
//
// @module COMMON.H
//
//-----------------------------------------------------------------------------------

#ifndef _COMMON_H_
#define _COMMON_H_


///////////////////////////////////////////////////////////////
// Defines
//
///////////////////////////////////////////////////////////////

//We want type checking on Window Handles
#define STRICT


enum EXCEPTION_SOURCE
{
	EXCEPTION_PROVIDER,
	EXCEPTION_APPLICATION,
};

enum SOURCE
{
	//Object Source
	DATASOURCE,
	DATASOURCEINIT,
	DATASOURCEADMIN,
	SESSION,
	COMMAND,
	ROWSET,
	ENUMERATOR,
	TRANSACTION,

	TRANSACTIONLOCAL,
	TRANSACTIONJOIN,
	MTSTRANSACTION,

	//Methods Source
	ROWSET_SETDATA,
	ROWSET_INSERTROW,
};


enum CONV_FLAGS
{
	CONV_NONE			= 0x00000000,
	CONV_VARBOOL		= 0x00000001,
	CONV_ALPHABOOL		= 0x00000002,
	CONV_HEX			= 0x00000004,
	CONV_OCTAL			= 0x00000008,
	CONV_DECIMAL		= 0x00000010,
	CONV_BINARY			= 0x00000020,
};


///////////////////////////////////////////////////////////////
// Includes
//
///////////////////////////////////////////////////////////////
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>	//InitCommonControls

#include <stddef.h>
#include <stdio.h>
#include <limits.h>
#include <wchar.h>
#include <ocidl.h>		//IConnectionPoint

#include "resource.h"

#include "oledb.h"		//OLE DB Header 
#include "oledberr.h"	//OLE DB Errors
#include "msdasc.H"		//OLE DB ServiceComponents

#include "Error.h"		//RowsetViewer file


////////////////////////////////////////////////////////////////////////////
// Windows Defines
//
////////////////////////////////////////////////////////////////////////////
#define CHECK_MEMORY(pv)	if(!pv) { OutOfMemory(NULL); goto CLEANUP; }

//Dialog Box procedures want to know if you handled the MSG
//or not.  If you do, thenit just returns, if not then it calls
//the default windialog procedure to try and handle it
const BOOL HANDLED_MSG	 = TRUE;
const BOOL UNHANDLED_MSG = FALSE;
#define LVM_ERR (-1)


///////////////////////////////////////////////////////////////
// Defines
//
///////////////////////////////////////////////////////////////
#define NUMELE(rgEle) (sizeof(rgEle) / sizeof(rgEle[0]))
#define __WIDESTRING(str) L##str
#define WIDESTRING(str) __WIDESTRING(str)

//FindLeaks
#if defined(_DEBUG) && defined(_IMALLOC_SPY)
#define DISP_FILE_LINE	TRACE("File '%s', Line '%lu'\n", __FILE__, __LINE__)
#else
#define DISP_FILE_LINE
#endif //_DEBUG && _IMALLOCSPY

//IMalloc Wrappers
#define SAFE_ALLOC(pv, type, cb)		{ DISP_FILE_LINE; pv = (type*)CoTaskMemAlloc((cb)*sizeof(type)); CHECK_MEMORY(pv);			}
#define SAFE_REALLOC(pv, type, cb)		{ DISP_FILE_LINE; pv = (type*)CoTaskMemRealloc(pv, (cb)*sizeof(type)); CHECK_MEMORY(pv);	}
#define SAFE_SYSALLOC(pv, bstr)			{ pv = SysAllocString(bstr); CHECK_MEMORY(pv);												}		

#define SAFE_FREE(pv)					{ CoTaskMemFree(pv); pv = NULL;						}
#define SAFE_SYSFREE(bstr)				{ SysFreeString(bstr); bstr = NULL;					}

//IUnknown->Release Wrapper
#define SAFE_ADDREF(pv)					if(pv) { (pv)->AddRef();							}
#define SAFE_RELEASE(pv)				if(pv) { (pv)->Release(); (pv) = NULL;				}  
#define SAFE_DELETE(pv)					if(pv) { delete pv; pv = NULL;	}  
																									
//Test macros																					
#define CHECKC(hr)						{ if(!(hr)) { ASSERT(!#hr); goto CLEANUP;			} }

//Exception Handling
#define PROVEXCEPTION(hWnd)				do { if(1 == HandleException(hWnd, EXCEPTION_PROVIDER,		WIDESTRING(__FILE__), __LINE__)) _DbgBreak(); } while (0)
#define APPEXCEPTION(hWnd)				do { if(1 == HandleException(hWnd, EXCEPTION_APPLICATION,	WIDESTRING(__FILE__), __LINE__)) _DbgBreak(); } while (0)

//Excpetion Handling (Try, Catch macros)
#ifdef USE_EXCEPTIONS
#define EXC_BEGIN						try {
#define EXC_END_PROV(hWnd)				} catch(...) { PROVEXCEPTION(hWnd);			} 
#define EXC_END_PROV_(hWnd, stmt)		} catch(...) { PROVEXCEPTION(hWnd);	 stmt;	} 
#define EXC_END(hWnd)					} catch(...) { APPEXCEPTION(hWnd);			} 
#define EXC_END_(hWnd, stmt)			} catch(...) { APPEXCEPTION(hWnd);	stmt;	} 
#else  //USE_EXCEPTIONS
#define EXC_BEGIN						
#define EXC_END_PROV(hWnd)				
#define EXC_END_PROV_(hWnd, stmt)		
#define EXC_END(hWnd)					
#define EXC_END_(hWnd, stmt)			

#endif //USE_EXCEPTIONS

//Error Checking
#define TESTC(hr)						{ if(FAILED(hr)) goto CLEANUP;				}
#define TESTC_(hr, hrExpected)			{ if((hr) != (hrExpected)) goto CLEANUP;	}

//Error Checking (with Exception Handling)
#define EXC_TEST(hr)					{ EXC_BEGIN hr;										EXC_END(NULL)					}
#define EXC_TESTC(hr)					{ EXC_BEGIN if(FAILED(hr)) goto CLEANUP;			EXC_END_(NULL, goto CLEANUP)	}
#define EXC_TESTC_(hr, hrExpected)		{ EXC_BEGIN if((hr) != (hrExpected)) goto CLEANUP;	EXC_END_(NULL, goto CLEANUP)	}

//Error Checking (with Exception Handling, and ErrorInfo checking)
//These Macros are used for calling all OLE DB Methods...
#define XTEST(hWnd, hr)					{ EXC_BEGIN DisplayAllErrors(hWnd, hr, WIDESTRING(__FILE__), __LINE__);											EXC_END_PROV(hWnd)					}
#define XTEST_(hWnd, hr, hrExpected)	{ EXC_BEGIN DisplayAllErrors(hWnd, hr, hrExpected, WIDESTRING(__FILE__), __LINE__);								EXC_END_PROV(hWnd)					}
#define XTESTC(hWnd, hr)				{ EXC_BEGIN if(FAILED(DisplayAllErrors(hWnd, hr, WIDESTRING(__FILE__), __LINE__))) goto CLEANUP;				EXC_END_PROV_(hWnd, goto CLEANUP)	}
#define XTESTC_(hWnd, hr, hrExpected)	{ EXC_BEGIN if(FAILED(DisplayAllErrors(hWnd, hr, hrExpected, WIDESTRING(__FILE__), __LINE__))) goto CLEANUP;	EXC_END_PROV_(hWnd, goto CLEANUP)	}


///////////////////////////////////////////////////////////////
// Defines
//
///////////////////////////////////////////////////////////////
#define MAX_QUERY_LEN			4096
#define MAX_NAME_LEN			256

#define MAX_COL_SIZE		    5000
#define MAX_BLOCK_SIZE			2000
#define MAX_OPENROWS			 256

//Displays values like VALUE as   VALUE , L"VALUE"
#define VALUE_WCHAR(value) value, L#value
#define VALUE_CHAR(value) value, #value

#define EOL		 '\0'
#define wEOL	L'\0'

#define ON		TRUE
#define OFF		FALSE


///////////////////////////////////////////////////////////////////
// Accessor / Binding 
//
///////////////////////////////////////////////////////////////////
//STATUS helpers, for locating obStatus offsets in the bindings
#define STATUS_IS_BOUND(Binding)    ( (Binding).dwPart & DBPART_STATUS )
#define BINDING_STATUS(Binding, pv) (*(ULONG*)((BYTE*)(pv) + (Binding).obStatus))

//LENGTH helpers, for locating obLength offsets in the bindings
#define LENGTH_IS_BOUND(Binding)    ( (Binding).dwPart & DBPART_LENGTH )
#define BINDING_LENGTH(Binding, pv) (*(ULONG*)((BYTE*)(pv) + (Binding).obLength))

//VALUE helpers, for locating obValue offsets in the bindings
#define VALUE_IS_BOUND(Binding)     ( (Binding).dwPart & DBPART_VALUE )
#define BINDING_VALUE(Binding, pv)  (*(ULONG*)((BYTE*)(pv) + (Binding).obValue ))

//ROUNDUP on all platforms pointers must be aligned properly
#define ROUNDUP_AMOUNT	8
#define ROUNDUP_(size,amount)		(((ULONG)(size)+((amount)-1))&~((amount)-1))
#define ROUNDUP(size)				ROUNDUP_(size, ROUNDUP_AMOUNT)

#define ENABLE_BIT(dwValue, dwBit, fEnable) ((fEnable) ? (dwValue) |= (dwBit) : (dwValue) &= ~(dwBit))

BOOL FreeBindings(ULONG* pcBindings, DBBINDING** prgBindings);
BOOL FreeBindingData(ULONG cBindings, DBBINDING* rgBindings, void* pData);


////////////////////////////////////////////////////////////////////////////
// DBTYPE functions
//
////////////////////////////////////////////////////////////////////////////
BOOL IsFixedType(DBTYPE wType);
BOOL IsVariableType(DBTYPE wType);
BOOL IsNumericType(DBTYPE wType);

WCHAR* GetDBTypeName(DBTYPE wType);
DBTYPE GetDBType(WCHAR* pwszName);
HRESULT GetDBTypeMaxSize(DBTYPE wType, ULONG* pulMaxSize = NULL, BYTE* pbPrecision = NULL, BYTE* pbScale = NULL);

CHAR* GetVariantTypeName(DBTYPE wType);
DBTYPE GetVariantType(CHAR* pszName);
			  


////////////////////////////////////////////////////////////////////////////
// OLEDB General Helper functions
//
////////////////////////////////////////////////////////////////////////////
HRESULT ConvertToMBCS(WCHAR* pwsz, CHAR* psz, ULONG cbStrLen);
HRESULT ConvertToWCHAR(CHAR* psz, WCHAR* pwsz, ULONG cbStrLen);
WCHAR* wcsDuplicate(WCHAR* pwsz);
CHAR*  strDuplicate(CHAR* psz);
WCHAR* ConvertToWCHAR(CHAR* psz);
CHAR* ConvertToMBCS(WCHAR* pwsz);

HRESULT BYTESToString(BYTE* pb, CHAR* pszBuffer, ULONG cBytes, ULONG* pulStrLen);
HRESULT StringToBYTES(CHAR* pszValue, BYTE* pb, ULONG cBytes, ULONG* pcBytes);


HRESULT DBIDToString(DBID* pDBID, WCHAR* pwsz, ULONG ulMaxLen);
HRESULT GUIDFromString(CHAR* psz, GUID* pGuid);

//Variants
HRESULT InitVariants(ULONG cVariants, VARIANT* rgVariants);
HRESULT FreeVariants(ULONG cVariants, VARIANT* rgVariants);

HRESULT ConvertString(CHAR* psz, ULONG ulMaxSize, DWORD dwFlags);
HRESULT VariantToString(VARIANT* pVariant, CHAR* psz, ULONG ulMaxSize, DWORD dwFlags);
HRESULT VariantToString(VARIANT* pVariant, WCHAR* pwsz, ULONG ulMaxSize, DWORD dwFlags);
HRESULT StringToVariant(WCHAR* pwsz, VARTYPE vt, VARIANT* pVariant, DWORD dwFlags);

HRESULT SafeArrayToString(SAFEARRAY* pSafeArray, DBTYPE wType, CHAR* psz, ULONG ulMaxSize);
HRESULT StringToSafeArray(WCHAR* pwsz, DBTYPE wType, SAFEARRAY** ppSafeArray);

//Restrictions
HRESULT SetRestriction(VARIANT* pRestriction, WCHAR* pwszValue);


////////////////////////////////////////////////////////////////////////////
// Windows functions
//
////////////////////////////////////////////////////////////////////////////
void Busy(BOOL bValue = TRUE);
void OutOfMemory(HWND hwnd);

INT wMessageBox(HWND hDlg, UINT uiStyle, WCHAR* pwszTitle, WCHAR* pwszFmt, ...);
INT MessageBox(HWND hDlg, UINT uiStyle, CHAR* pszTitle, CHAR* pszFmt, ...);

LRESULT wSendMessage(HWND hWnd, UINT Msg, WPARAM wParam, WCHAR* pwszFmt);
LRESULT wSendMessageFmt(HWND hWnd, UINT Msg, WPARAM wParam, WCHAR* pwszFmt, ...);
LRESULT SendMessageFmt(HWND hWnd, UINT Msg, WPARAM wParam, CHAR* pszFmt, ...);

BOOL CenterDialog(HWND hDlg);
BOOL MoveWindow(HWND hWnd, ULONG x, ULONG y);
SIZE GetWindowSize(HWND hWnd);
void SyncSibling(HWND hwndLstChg,HWND hwndLstSrc);

BOOL GetEditBoxValue(HWND hEditWnd, LONG lMin, LONG lMax, LONG* plValue, BOOL fAllowEmpty = FALSE);
HRESULT	ReplaceString(CHAR* pszBuffer, CHAR* pszTokens, CHAR* pszReplace);
HRESULT	GetEditBoxSelection(HWND hWndEdit, CHAR* pszBuffer, ULONG ulMaxSize);
HRESULT	ReplaceEditBoxSelection(HWND hWndEdit, CHAR* pszBuffer);
BOOL DisplayContextMenu(HINSTANCE hInst, HWND hWnd, WORD iID, INT xPos, INT yPos, HWND hWndParent, BOOL fRelCords = FALSE);

HRESULT BrowseOpenFileName(HINSTANCE hInstance, HWND hWnd, CHAR* pszTitle, CHAR*  pszFileName,  ULONG ulMaxSize);
HRESULT BrowseOpenFileName(HINSTANCE hInstance, HWND hWnd, CHAR* pszTitle, WCHAR* pwszFileName, ULONG ulMaxSize);
HRESULT BrowseSaveFileName(HINSTANCE hInstance, HWND hWnd, CHAR* pszTitle, CHAR*  pszFileName,  ULONG ulMaxSize);
HRESULT BrowseSaveFileName(HINSTANCE hInstance, HWND hWnd, CHAR* pszTitle, WCHAR* pwszFileName, ULONG ulMaxSize);


/////////////////////////////////////////////////////////////////////
// Combo Helpers
//
/////////////////////////////////////////////////////////////////////
LONG CB_GetSelectedText(HWND hWndCombo, CHAR* pszBuffer, ULONG ulMaxSize);
LONG CB_GetSelectedText(HWND hWndCombo, WCHAR* pwszBuffer, ULONG ulMaxSize);
LONG CB_SelectText(HWND hWndCombo, CHAR* pszBuffer, BOOL fAddItem);
LONG CB_SelectText(HWND hWndCombo, WCHAR* pwszBuffer, BOOL fAddItem);
LONG CB_SelectItemValue(HWND hWndCombo, LONG lParam);


/////////////////////////////////////////////////////////////////////
// ListView Helpers
//
/////////////////////////////////////////////////////////////////////
#define IMAGE_NONE -1
#define PARAM_NONE -1

LONG LV_InsertColumn(HWND hWnd, LONG iColumn, CHAR* szName, LONG iImage = IMAGE_NONE);
LONG LV_InsertItem(HWND hWnd, LONG iItem, LONG iSubItem, CHAR* szName, LONG iParam = PARAM_NONE, LONG iImage = IMAGE_NONE);

LONG LV_SetItemState(HWND hWnd, LONG iItem, LONG iSubItem, LONG lState, LONG lStateMask);
LONG LV_SetItemText(HWND hWnd, LONG iItem, LONG iSubItem, CHAR* szName);
LONG LV_SetItemImage(HWND hWnd, LONG iItem, LONG iSubItem, LONG iImage);
LONG LV_SetItemParam(HWND hWnd, LONG iItem, LONG iSubItem, LONG lParam);

LONG LV_GetItemState(HWND hWnd, LONG iItem, LONG iMask = 0);
LONG LV_GetItemText(HWND hWnd, LONG iItem, LONG iSubItem, CHAR* szName, ULONG ulMaxSize);
LONG LV_GetItemImage(HWND hWnd, LONG iItem, LONG iSubItem);
LONG LV_GetItemParam(HWND hWnd, LONG iItem, LONG iSubItem);

LONG LV_FindItem(HWND hWnd, CHAR* szName, LONG iStart = -1);
LONG LV_FindItem(HWND hWnd, LPARAM lParam, LONG iStart = -1);
														 
LONG LV_GetSelItems(HWND hWnd, ULONG* pcItems = NULL, LONG** prgSelItems = NULL, LONG** prgSelParams = NULL);
LONG LV_GetAllItems(HWND hWnd, ULONG* pcItems = NULL, LONG** prgItems = NULL, LONG** prgParams = NULL);


/////////////////////////////////////////////////////////////////////
// TreeView Helpers
//
/////////////////////////////////////////////////////////////////////
HTREEITEM TV_InsertItem(HWND hWnd, HTREEITEM hParent, HTREEITEM hInsAfter, CHAR* szName, LONG iParam = 0, LONG iImage = 0, LONG iSelectedImage = 0);
HTREEITEM TV_FindItem(HWND hWnd, HTREEITEM hParent, CHAR* szName);
LONG TV_GetItemText(HWND hWnd, HTREEITEM hItem, CHAR* szBuffer, LONG ulMaxSize);
LONG TV_GetItemParam(HWND hWnd, HTREEITEM hItem);


/////////////////////////////////////////////////////////////////////
// ScrollBar Helpers
//
/////////////////////////////////////////////////////////////////////
LONG SB_SetScrollInfo(HWND hWnd, INT dwFlags, INT iPos, INT iRangeSize, INT iPageSize, BOOL fRedraw = FALSE);
LONG SB_GetScrollInfo(HWND hWnd, INT dwFlags, INT* piPos, INT* piRangeSize, INT* piPageSize);


///////////////////////////////////////////////////////////////
// Registry
//
///////////////////////////////////////////////////////////////
WCHAR*	GetProgID(CLSID clsid);
HRESULT GetRegEnumKey(HKEY hRootKey, CHAR* pszKeyName, DWORD dwIndex, CHAR* pszSubKeyName, ULONG cBytes);
HRESULT GetRegEnumValue(HKEY hRootKey, CHAR* pszKeyName, DWORD dwIndex, CHAR* pszValueName, ULONG cBytes);
HRESULT GetRegEnumValue(HKEY hRootKey, CHAR* pszKeyName, DWORD dwIndex, WCHAR* pwszValueName, ULONG cBytes);

HRESULT GetRegEntry(HKEY hRootKey, CHAR* pszKeyName, CHAR* pszValueName, CHAR* pszValue, ULONG cBytes);
HRESULT GetRegEntry(HKEY hRootKey, CHAR* pszKeyName, CHAR* pszValueName, WCHAR* pwszValue, ULONG cBytes);
HRESULT GetRegEntry(HKEY hRootKey, CHAR* pszKeyName, CHAR* pszValueName, ULONG* pulValue);

HRESULT SetRegEntry(HKEY hRootKey, CHAR* pszKeyName, CHAR* pszValueName, CHAR* pszValue);
HRESULT SetRegEntry(HKEY hRootKey, CHAR* pszKeyName, CHAR* pszValueName, WCHAR* pwszValue);
HRESULT SetRegEntry(HKEY hRootKey, CHAR* pszKeyName, CHAR* pszValueName, ULONG ulValue);

HRESULT DelRegEntry(HKEY hRootKey, CHAR* pszKeyName);


/////////////////////////////////////////////////////////////////////
// Exception Handlers
//
/////////////////////////////////////////////////////////////////////
HRESULT HandleException(HWND hWnd, EXCEPTION_SOURCE eSource, WCHAR* pwszFile, ULONG iLine);


/////////////////////////////////////////////////////////////////////
// Memory debugging code
//
/////////////////////////////////////////////////////////////////////
int InternalAssert(char* pszExp, char* pszFile, UINT iLine);
void InternalTrace(CHAR* pszExp, ...);
void InternalTrace(WCHAR* pwszExp, ...);

#undef ASSERT
#undef TRACE

//DebugBreak
#if     defined(_M_IX86)
#define _DbgBreak() __asm { int 3 }
#else
#define _DbgBreak() DebugBreak()
#endif

#ifdef _DEBUG
#define ASSERT(expr)	do { if(!(expr) && (1 == InternalAssert(#expr, __FILE__, __LINE__))) _DbgBreak(); } while(0)
#define TRACE			InternalTrace
#else  //_DEBUG
#define ASSERT(exp)
#define TRACE			if(0) InternalTrace
#endif //_DEBUG


/////////////////////////////////////////////////////////////////////////////
// 	Name MAPS
//
/////////////////////////////////////////////////////////////////////////////
extern const ULONG g_cInterfaceMaps;
extern const GUIDMAP g_rgInterfaceMap[];

extern const ULONG g_cDBTypes;
extern const WIDENAMEMAP g_rgDBTypes[];

extern const ULONG g_cPropSetMaps;
extern const GUIDMAP g_rgPropSetMap[];

extern const ULONG g_cVariantTypes;
extern const NAMEMAP g_rgVariantTypes[];
			 
extern const NAMEMAP g_rgIsoLevels[];
extern const ULONG g_cIsoLevels;

extern const NAMEMAP g_rgXACTTC[];
extern const ULONG g_cXACTTC;

///////////////////////////////////////////////////////////////
// Static Strings Messages
//
///////////////////////////////////////////////////////////////

//General Status
extern WCHAR wsz_SUCCESS[];				
extern WCHAR wsz_WARNING[];				
extern WCHAR wsz_INFO[];
extern WCHAR wsz_ERROR[];				
extern WCHAR wsz_EXCEPTION[];
extern WCHAR wsz_ERRORINFO[];			
								 
//General String Values
extern WCHAR wsz_INVALID_VALUE_[];	

#endif //_COMMON_H_
